
import oracle.xml.parser.schema.*;
import oracle.xml.parser.v2.*;
import oracle.xml.util.XMLUtil;

import java.net.*;
import java.io.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import java.util.*;

public class xsdent
{
  public static void main(String[] args) throws Exception 
  {
      String xmlfile;
      xmlfile =  args[0];

      String xsdfile;
      xsdfile =  args[1];
      System.out.println ("-- process file: " + xmlfile + "  "+ xsdfile);

      XSDBuilder builder = new XSDBuilder();
      URL    url =  XMLUtil.createURL(xsdfile);     
      builder.setEntityResolver(new sampleEntityResolver1());
      Object schemadoc;

      try
      {
         schemadoc = builder.build(url);
         process(xmlfile, schemadoc);
      }
      catch (Exception e)
      {
         ; // need not do anything as the error would be printed in logfile
      }

      builder = new XSDBuilder();
      url =  XMLUtil.createURL(xsdfile);     
      builder.setEntityResolver(new sampleEntityResolver2());

      try
      {
         schemadoc = builder.build(url);
         process(xmlfile, schemadoc);
      }
      catch (Exception e)
      {
         ; // need not do anything as the error would be printed in logfile
      }

  }

  public static void process(String xmlURI, Object schemadoc) 
      throws Exception 
    {

    DOMParser dp  = new DOMParser();
    URL       url = XMLUtil.createURL (xmlURI);

    dp.setXMLSchema(schemadoc);
    dp.setValidationMode(XMLParser.SCHEMA_VALIDATION);
    dp.setPreserveWhitespace (true);

    dp.setErrorStream (System.out);

    try {
       dp.parse (url);
    } catch (XMLParseException pe) {
       ;
    } catch (Exception e) { 
       e.printStackTrace();
       System.out.println ("");
       System.out.println ("NonParserException: " + e.getMessage()); 
    }

  }
}

class sampleEntityResolver1 implements EntityResolver
{
   public InputSource resolveEntity (String targetNS,  String systemId)
   throws SAXException, IOException
   {
      // perform any validation check if needed based on targetNS & systemId

      InputSource mySource = null;
      URL u = XMLUtil.createURL(systemId);
      
      // Create input source with InputStream as input
      mySource = new InputSource(u.openStream());
      mySource.setSystemId(systemId);
      return mySource;
   }
}

class sampleEntityResolver2 implements EntityResolver
{
   public InputSource resolveEntity (String targetNS,  String systemId)
   throws SAXException, IOException
   {
      // perform any validation check if needed based on targetNS & systemId

      InputSource mySource = null;
      URL u = XMLUtil.createURL(systemId);
      // Create input source with URL
      mySource = new InputSource(u.toString());
      return mySource;
   }
}
